package app.firezone.synk.network.Activities;

import android.app.ProgressDialog;
import android.os.Bundle;
import android.widget.Toast;

import androidx.appcompat.app.AppCompatActivity;

import app.firezone.synk.network.API.APIClient;
import app.firezone.synk.network.API.MyApi;
import app.firezone.synk.network.databinding.ActivityChangePasswordBinding;
import app.firezone.synk.network.model.ApiResponse;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class ChangePasswordActivity extends AppCompatActivity {

    ActivityChangePasswordBinding binding;
    private MyApi myApi;
    String password;
    long userId;
    ProgressDialog progressDialog;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        binding = ActivityChangePasswordBinding.inflate(getLayoutInflater());
        setContentView(binding.getRoot());

        binding.backArrow.setOnClickListener(v -> finish());

        progressDialog = new ProgressDialog(ChangePasswordActivity.this);
        progressDialog.setTitle("Update Started");
        progressDialog.setMessage("Please wait.....");

        password = getIntent().getStringExtra("password");
        userId = getIntent().getLongExtra("userId", 0);

        binding.btnChangePass.setOnClickListener(v -> {
            String currentPass = binding.previousPass.getText().toString().trim();
            String pass1 = binding.pass1.getText().toString().trim();
            String pass2 = binding.pass2.getText().toString().trim();

            if (currentPass.isEmpty() || pass1.isEmpty() || pass2.isEmpty()) {
                Toast.makeText(ChangePasswordActivity.this, "All fields are required", Toast.LENGTH_SHORT).show();
                return;
            }

            if (!pass1.equals(pass2)) {
                binding.pass1.setError("Passwords do not match");
                binding.pass2.setError("Passwords do not match");
                Toast.makeText(ChangePasswordActivity.this, "Password and Confirm Password do not match.", Toast.LENGTH_SHORT).show();
                return;
            }

            changesPassword(pass1, currentPass);
        });
    }

    private void changesPassword(String newPass, String currentPass) {
        myApi = APIClient.getApiClient(getApplicationContext()).create(MyApi.class);

        Call<ApiResponse> call = myApi.changePassword(userId, currentPass, newPass);

        progressDialog.show();

        call.enqueue(new Callback<ApiResponse>() {
            @Override
            public void onResponse(Call<ApiResponse> call, Response<ApiResponse> response) {
                progressDialog.dismiss();
                if (response.isSuccessful() && response.body() != null) {
                    if (response.body().getStatus() == 200) {
                        Toast.makeText(ChangePasswordActivity.this, "Password updated successfully!", Toast.LENGTH_SHORT).show();
                        finish();
                    } else {
                        Toast.makeText(ChangePasswordActivity.this, response.body().getMessage(), Toast.LENGTH_SHORT).show();
                    }
                } else {
                    Toast.makeText(ChangePasswordActivity.this, "Error: " + response.errorBody(), Toast.LENGTH_SHORT).show();
                }

            }

            @Override
            public void onFailure(Call<ApiResponse> call, Throwable t) {
                progressDialog.dismiss();
                Toast.makeText(ChangePasswordActivity.this, "Request failed: " + t.getMessage(), Toast.LENGTH_SHORT).show();
            }
        });
    }

}
